/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.ratatouille.client.lib.render.systems.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.doctor4t.ratatouille.client.lib.render.helpers.RenderHelper;
import dev.doctor4t.ratatouille.client.lib.render.systems.rendering.TrailPoint;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class VFXBuilders {
    public static ScreenVFXBuilder createScreen() {
        return new ScreenVFXBuilder();
    }

    public static WorldVFXBuilder createWorld() {
        return new WorldVFXBuilder();
    }

    public static class ScreenVFXBuilder {
        public float r = 1.0f;
        public float g = 1.0f;
        public float b = 1.0f;
        public float a = 1.0f;
        public int light = -1;
        public float u0 = 0.0f;
        public float v0 = 0.0f;
        public float u1 = 1.0f;
        public float v1 = 1.0f;
        public float x0 = 0.0f;
        public float y0 = 0.0f;
        public float x1 = 1.0f;
        public float y1 = 1.0f;
        public int zLevel;
        public class_293 format;
        public Supplier<class_5944> shader = class_757::method_34542;
        public class_2960 texture;
        public ScreenVertexPlacementSupplier supplier;
        public class_287 bufferbuilder = class_289.method_1348().method_1349();

        public ScreenVFXBuilder setPosTexDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.method_22918(l, x, y, (float)this.zLevel).method_22913(u, v).method_1344();
            this.format = class_290.field_1585;
            return this;
        }

        public ScreenVFXBuilder setPosColorDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.method_22918(l, x, y, (float)this.zLevel).method_22915(this.r, this.g, this.b, this.a).method_1344();
            this.format = class_290.field_1576;
            return this;
        }

        public ScreenVFXBuilder setPosColorTexDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.method_22918(l, x, y, (float)this.zLevel).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_1344();
            this.format = class_290.field_20887;
            return this;
        }

        public ScreenVFXBuilder setPosColorTexLightmapDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.method_22918(l, x, y, (float)this.zLevel).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_22916(this.light).method_1344();
            this.format = class_290.field_20888;
            return this;
        }

        public ScreenVFXBuilder setFormat(class_293 format) {
            this.format = format;
            return this;
        }

        public ScreenVFXBuilder setShaderTexture(class_2960 texture) {
            this.texture = texture;
            return this;
        }

        public ScreenVFXBuilder setShader(Supplier<class_5944> shader) {
            this.shader = shader;
            return this;
        }

        public ScreenVFXBuilder setShader(class_5944 shader) {
            this.shader = () -> shader;
            return this;
        }

        public ScreenVFXBuilder setVertexSupplier(ScreenVertexPlacementSupplier supplier) {
            this.supplier = supplier;
            return this;
        }

        public ScreenVFXBuilder overrideBufferBuilder(class_287 builder) {
            this.bufferbuilder = builder;
            return this;
        }

        public ScreenVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public ScreenVFXBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public ScreenVFXBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public ScreenVFXBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public ScreenVFXBuilder setColor(float r, float g, float b) {
            this.r = r / 255.0f;
            this.g = g / 255.0f;
            this.b = b / 255.0f;
            return this;
        }

        public ScreenVFXBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public ScreenVFXBuilder setPositionWithWidth(float x, float y, float width, float height) {
            return this.setPosition(x, y, x + width, y + height);
        }

        public ScreenVFXBuilder setPosition(float x0, float y0, float x1, float y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            return this;
        }

        public ScreenVFXBuilder setZLevel(int z) {
            this.zLevel = z;
            return this;
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSize) {
            return this.setUVWithWidth(u, v, width, height, canvasSize, canvasSize);
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSizeX, float canvasSizeY) {
            return this.setUVWithWidth(u / canvasSizeX, v / canvasSizeY, width / canvasSizeX, height / canvasSizeY);
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height) {
            this.u0 = u;
            this.v0 = v;
            this.u1 = u + width;
            this.v1 = v + height;
            return this;
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSize) {
            return this.setUV(u0, v0, u1, v1, canvasSize, canvasSize);
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSizeX, float canvasSizeY) {
            return this.setUV(u0 / canvasSizeX, v0 / canvasSizeY, u1 / canvasSizeX, v1 / canvasSizeY);
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public ScreenVFXBuilder begin() {
            this.bufferbuilder.method_1328(class_293.class_5596.field_27382, this.format);
            return this;
        }

        public ScreenVFXBuilder blit(class_4587 stack) {
            Matrix4f last = stack.method_23760().method_23761();
            RenderSystem.setShader(this.shader);
            if (this.texture != null) {
                RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
            }
            this.supplier.placeVertex(this.bufferbuilder, last, this.x0, this.y1, this.u0, this.v1);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x1, this.y1, this.u1, this.v1);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x1, this.y0, this.u1, this.v0);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x0, this.y0, this.u0, this.v0);
            return this;
        }

        public ScreenVFXBuilder blit(class_4587 stack, Consumer<ScreenVFXBuilder> gradientConsumer) {
            Matrix4f last = stack.method_23760().method_23761();
            RenderSystem.setShader(this.shader);
            if (this.texture != null) {
                RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
            }
            this.supplier.placeVertex(this.bufferbuilder, last, this.x0, this.y1, this.u0, this.v1);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x1, this.y1, this.u1, this.v1);
            gradientConsumer.accept(this);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x1, this.y0, this.u1, this.v0);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x0, this.y0, this.u0, this.v0);
            return this;
        }

        public ScreenVFXBuilder run(Consumer<ScreenVFXBuilder> consumer) {
            consumer.accept(this);
            return this;
        }

        public ScreenVFXBuilder end() {
            class_286.method_43437((class_287.class_7433)this.bufferbuilder.method_1326());
            return this;
        }

        public ScreenVFXBuilder draw(class_4587 stack) {
            if (this.bufferbuilder.method_22893()) {
                this.bufferbuilder.method_1326();
            }
            this.begin();
            this.blit(stack);
            this.end();
            return this;
        }

        public static interface ScreenVertexPlacementSupplier {
            public void placeVertex(class_287 var1, Matrix4f var2, float var3, float var4, float var5, float var6);
        }
    }

    public static class WorldVFXBuilder {
        protected float r = 1.0f;
        protected float g = 1.0f;
        protected float b = 1.0f;
        protected float a = 1.0f;
        protected float xOffset = 0.0f;
        protected float yOffset = 0.0f;
        protected float zOffset = 0.0f;
        protected int light = 0xF000F0;
        protected float u0 = 0.0f;
        protected float v0 = 0.0f;
        protected float u1 = 1.0f;
        protected float v1 = 1.0f;
        class_293 format;
        WorldVertexPlacementSupplier supplier;

        public WorldVFXBuilder setPosColorDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.method_22912((double)x, (double)y, (double)z).method_22915(this.r, this.g, this.b, this.a).method_1344();
                } else {
                    c.method_22918(l, x, y, z).method_22915(this.r, this.g, this.b, this.a).method_1344();
                }
            }).setFormat(class_290.field_1576);
        }

        public WorldVFXBuilder setPosColorLightmapDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.method_22912((double)x, (double)y, (double)z).method_22915(this.r, this.g, this.b, this.a).method_22916(this.light).method_1344();
                } else {
                    c.method_22918(l, x, y, z).method_22915(this.r, this.g, this.b, this.a).method_22916(this.light).method_1344();
                }
            }).setFormat(class_290.field_21468);
        }

        public WorldVFXBuilder setPosTexDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.method_22912((double)x, (double)y, (double)z).method_22913(u, v).method_1344();
                } else {
                    c.method_22918(l, x, y, z).method_22913(u, v).method_1344();
                }
            }).setFormat(class_290.field_1585);
        }

        public WorldVFXBuilder setPosColorTexDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.method_22912((double)x, (double)y, (double)z).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_1344();
                } else {
                    c.method_22918(l, x, y, z).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_1344();
                }
            }).setFormat(class_290.field_20887);
        }

        public WorldVFXBuilder setPosColorTexLightmapDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.method_22912((double)x, (double)y, (double)z).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_22916(this.light).method_1344();
                } else {
                    c.method_22918(l, x, y, z).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_22916(this.light).method_1344();
                }
            }).setFormat(class_290.field_20888);
        }

        public WorldVFXBuilder setFormat(class_293 format) {
            this.format = format;
            return this;
        }

        public WorldVFXBuilder setVertexSupplier(WorldVertexPlacementSupplier supplier) {
            this.supplier = supplier;
            return this;
        }

        public WorldVFXBuilder setColorWithAlpha(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue(), (float)color.getAlpha() / 255.0f);
        }

        public WorldVFXBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public WorldVFXBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public WorldVFXBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public WorldVFXBuilder setColor(float r, float g, float b) {
            this.r = r / 255.0f;
            this.g = g / 255.0f;
            this.b = b / 255.0f;
            return this;
        }

        public WorldVFXBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public WorldVFXBuilder setOffset(float xOffset, float yOffset, float zOffset) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
            return this;
        }

        public WorldVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public WorldVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public WorldVFXBuilder renderPoints(class_4588 vertexConsumer, List<TrailPoint> trailPoints, float u0, float v0, float u1, float v1, Consumer<Float> vfxOperator) {
            int count = trailPoints.size() - 1;
            float increment = 1.0f / (float)count;
            vfxOperator.accept(Float.valueOf(0.0f));
            trailPoints.get(0).renderStart(vertexConsumer, this.supplier, u0, v0, u1, class_3532.method_16439((float)increment, (float)v0, (float)v1));
            for (int i = 1; i < count; ++i) {
                float current = class_3532.method_16439((float)((float)i * increment), (float)v0, (float)v1);
                vfxOperator.accept(Float.valueOf(current));
                trailPoints.get(i).renderMid(vertexConsumer, this.supplier, u0, current, u1, current);
            }
            vfxOperator.accept(Float.valueOf(1.0f));
            trailPoints.get(count).renderEnd(vertexConsumer, this.supplier, u0, class_3532.method_16439((float)((float)count * increment), (float)v0, (float)v1), u1, v1);
            return this;
        }

        public WorldVFXBuilder renderBeam(class_4588 vertexConsumer, class_4587 stack, class_243 start, class_243 end, float width) {
            class_310 minecraft = class_310.method_1551();
            start.method_1031((double)this.xOffset, (double)this.yOffset, (double)this.zOffset);
            end.method_1031((double)this.xOffset, (double)this.yOffset, (double)this.zOffset);
            stack.method_22904(-start.field_1352, -start.field_1351, -start.field_1350);
            class_243 cameraPosition = minecraft.method_31975().field_4344.method_19326();
            class_243 delta = end.method_1020(start);
            class_243 normal = start.method_1020(cameraPosition).method_1036(delta).method_1029().method_18805((double)(width / 2.0f), (double)(width / 2.0f), (double)(width / 2.0f));
            Matrix4f last = stack.method_23760().method_23761();
            class_243[] positions = new class_243[]{start.method_1020(normal), start.method_1019(normal), end.method_1019(normal), end.method_1020(normal)};
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[0].field_1352, (float)positions[0].field_1351, (float)positions[0].field_1350, this.u0, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[1].field_1352, (float)positions[1].field_1351, (float)positions[1].field_1350, this.u1, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[2].field_1352, (float)positions[2].field_1351, (float)positions[2].field_1350, this.u1, this.v0);
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[3].field_1352, (float)positions[3].field_1351, (float)positions[3].field_1350, this.u0, this.v0);
            stack.method_22904(start.field_1352, start.field_1351, start.field_1350);
            return this;
        }

        public WorldVFXBuilder renderQuad(class_4588 vertexConsumer, class_4587 stack, float size) {
            return this.renderQuad(vertexConsumer, stack, size, size);
        }

        public WorldVFXBuilder renderQuad(class_4588 vertexConsumer, class_4587 stack, float width, float height) {
            Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f)};
            return this.renderQuad(vertexConsumer, stack, positions, width, height);
        }

        public WorldVFXBuilder renderQuad(class_4588 vertexConsumer, class_4587 stack, Vector3f[] positions, float size) {
            return this.renderQuad(vertexConsumer, stack, positions, size, size);
        }

        public WorldVFXBuilder renderQuad(class_4588 vertexConsumer, class_4587 stack, Vector3f[] positions, float width, float height) {
            Matrix4f last = stack.method_23760().method_23761();
            stack.method_46416(this.xOffset, this.yOffset, this.zOffset);
            for (Vector3f position : positions) {
                position.mul(width, height, width);
            }
            this.supplier.placeVertex(vertexConsumer, last, positions[0].x(), positions[0].y(), positions[0].z(), this.u0, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, positions[1].x(), positions[1].y(), positions[1].z(), this.u1, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, positions[2].x(), positions[2].y(), positions[2].z(), this.u1, this.v0);
            this.supplier.placeVertex(vertexConsumer, last, positions[3].x(), positions[3].y(), positions[3].z(), this.u0, this.v0);
            stack.method_46416(-this.xOffset, -this.yOffset, -this.zOffset);
            return this;
        }

        public WorldVFXBuilder renderSphere(class_4588 vertexConsumer, class_4587 stack, float radius, int longs, int lats) {
            Matrix4f last = stack.method_23760().method_23761();
            float startU = 0.0f;
            float startV = 0.0f;
            float endU = (float)Math.PI * 2;
            float endV = (float)Math.PI;
            float stepU = (endU - startU) / (float)longs;
            float stepV = (endV - startV) / (float)lats;
            for (int i = 0; i < longs; ++i) {
                for (int j = 0; j < lats; ++j) {
                    float u = (float)i * stepU + startU;
                    float v = (float)j * stepV + startV;
                    float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                    float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                    Vector3f p0 = RenderHelper.parametricSphere(u, v, radius);
                    Vector3f p1 = RenderHelper.parametricSphere(u, vn, radius);
                    Vector3f p2 = RenderHelper.parametricSphere(un, v, radius);
                    Vector3f p3 = RenderHelper.parametricSphere(un, vn, radius);
                    float textureU = u / endU * radius;
                    float textureV = v / endV * radius;
                    float textureUN = un / endU * radius;
                    float textureVN = vn / endV * radius;
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p0.x(), p0.y(), p0.z(), this.r, this.g, this.b, this.a, textureU, textureV, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p2.x(), p2.y(), p2.z(), this.r, this.g, this.b, this.a, textureUN, textureV, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p1.x(), p1.y(), p1.z(), this.r, this.g, this.b, this.a, textureU, textureVN, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p3.x(), p3.y(), p3.z(), this.r, this.g, this.b, this.a, textureUN, textureVN, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p1.x(), p1.y(), p1.z(), this.r, this.g, this.b, this.a, textureU, textureVN, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p2.x(), p2.y(), p2.z(), this.r, this.g, this.b, this.a, textureUN, textureV, this.light);
                }
            }
            return this;
        }

        public static interface WorldVertexPlacementSupplier {
            public void placeVertex(class_4588 var1, Matrix4f var2, float var3, float var4, float var5, float var6, float var7);
        }
    }
}

